
# Order Line Item Discount

Represents a discount that applies to one or more line items in an
order.

Fixed-amount, order-scoped discounts are distributed across all non-zero line item totals.
The amount distributed to each line item is relative to the
amount contributed by the item to the order subtotal.

## Structure

`OrderLineItemDiscount`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `uid` | `?string` | Optional | A unique ID that identifies the discount only within this order.<br>**Constraints**: *Maximum Length*: `60` | getUid(): ?string | setUid(?string uid): void |
| `catalogObjectId` | `?string` | Optional | The catalog object ID referencing [CatalogDiscount](../../doc/models/catalog-discount.md).<br>**Constraints**: *Maximum Length*: `192` | getCatalogObjectId(): ?string | setCatalogObjectId(?string catalogObjectId): void |
| `catalogVersion` | `?int` | Optional | The version of the catalog object that this discount references. | getCatalogVersion(): ?int | setCatalogVersion(?int catalogVersion): void |
| `name` | `?string` | Optional | The discount's name.<br>**Constraints**: *Maximum Length*: `255` | getName(): ?string | setName(?string name): void |
| `type` | [`?string (OrderLineItemDiscountType)`](../../doc/models/order-line-item-discount-type.md) | Optional | Indicates how the discount is applied to the associated line item or order. | getType(): ?string | setType(?string type): void |
| `percentage` | `?string` | Optional | The percentage of the discount, as a string representation of a decimal number.<br>A value of `7.25` corresponds to a percentage of 7.25%.<br><br>`percentage` is not set for amount-based discounts.<br>**Constraints**: *Maximum Length*: `10` | getPercentage(): ?string | setPercentage(?string percentage): void |
| `amountMoney` | [`?Money`](../../doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. | getAmountMoney(): ?Money | setAmountMoney(?Money amountMoney): void |
| `appliedMoney` | [`?Money`](../../doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. | getAppliedMoney(): ?Money | setAppliedMoney(?Money appliedMoney): void |
| `metadata` | `?array<string,string>` | Optional | Application-defined data attached to this discount. Metadata fields are intended<br>to store descriptive references or associations with an entity in another system or store brief<br>information about the object. Square does not process this field; it only stores and returns it<br>in relevant API calls. Do not use metadata to store any sensitive information (such as personally<br>identifiable information or card details).<br><br>Keys written by applications must be 60 characters or less and must be in the character set<br>`[a-zA-Z0-9_-]`. Entries can also include metadata generated by Square. These keys are prefixed<br>with a namespace, separated from the key with a ':' character.<br><br>Values have a maximum length of 255 characters.<br><br>An application can have up to 10 entries per metadata field.<br><br>Entries written by applications are private and can only be read or modified by the same<br>application.<br><br>For more information, see [Metadata](https://developer.squareup.com/docs/build-basics/metadata). | getMetadata(): ?array | setMetadata(?array metadata): void |
| `scope` | [`?string (OrderLineItemDiscountScope)`](../../doc/models/order-line-item-discount-scope.md) | Optional | Indicates whether this is a line-item or order-level discount. | getScope(): ?string | setScope(?string scope): void |
| `rewardIds` | `?(string[])` | Optional | The reward IDs corresponding to this discount. The application and<br>specification of discounts that have `reward_ids` are completely controlled by the backing<br>criteria corresponding to the reward tiers of the rewards that are added to the order<br>through the Loyalty API. To manually unapply discounts that are the result of added rewards,<br>the rewards must be removed from the order through the Loyalty API. | getRewardIds(): ?array | setRewardIds(?array rewardIds): void |
| `pricingRuleId` | `?string` | Optional | The object ID of a [pricing rule](../../doc/models/catalog-pricing-rule.md) to be applied<br>automatically to this discount. The specification and application of the discounts, to<br>which a `pricing_rule_id` is assigned, are completely controlled by the corresponding<br>pricing rule. | getPricingRuleId(): ?string | setPricingRuleId(?string pricingRuleId): void |

## Example (as JSON)

```json
{
  "uid": null,
  "catalog_object_id": null,
  "catalog_version": null,
  "name": null,
  "type": null,
  "percentage": null,
  "amount_money": null,
  "applied_money": null,
  "metadata": null,
  "scope": null,
  "reward_ids": null,
  "pricing_rule_id": null
}
```

