
# Catalog Image

An image file to use in Square catalogs. It can be associated with
`CatalogItem`, `CatalogItemVariation`, `CatalogCategory`, and `CatalogModifierList` objects.
Only the images on items and item variations are exposed in Dashboard.
Only the first image on an item is displayed in Square Point of Sale (SPOS).
Images on items and variations are displayed through Square Online Store.
Images on other object types are for use by 3rd party application developers.

## Structure

`CatalogImage`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `name` | `?string` | Optional | The internal name to identify this image in calls to the Square API.<br>This is a searchable attribute for use in applicable query filters<br>using the [SearchCatalogObjects](../../doc/apis/catalog.md#search-catalog-objects).<br>It is not unique and should not be shown in a buyer facing context. | getName(): ?string | setName(?string name): void |
| `url` | `?string` | Optional | The URL of this image, generated by Square after an image is uploaded<br>using the [CreateCatalogImage](../../doc/apis/catalog.md#create-catalog-image) endpoint.<br>To modify the image, use the UpdateCatalogImage endpoint. Do not change the URL field. | getUrl(): ?string | setUrl(?string url): void |
| `caption` | `?string` | Optional | A caption that describes what is shown in the image. Displayed in the<br>Square Online Store. This is a searchable attribute for use in applicable query filters<br>using the [SearchCatalogObjects](../../doc/apis/catalog.md#search-catalog-objects). | getCaption(): ?string | setCaption(?string caption): void |
| `photoStudioOrderId` | `?string` | Optional | The immutable order ID for this image object created by the Photo Studio service in Square Online Store. | getPhotoStudioOrderId(): ?string | setPhotoStudioOrderId(?string photoStudioOrderId): void |

## Example (as JSON)

```json
{
  "name": null,
  "url": null,
  "caption": null,
  "photo_studio_order_id": null
}
```

